/******************************************************************************
 * %Id: dev-share.h 154 2010-02-24 10:31:59Z 4011017 $
 *
 * FileName		:dev-share.h
 *
 * Description	:Inner header file for dev-share.c
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef IOSC_DEV_SHARE_H
#define IOSC_DEV_SHARE_H

#if defined(CONFIG_SMP)
#define __SMP__
#endif

#if defined(CONFIG_MODVERSIONS)
#define MODVERSIONS
#endif

#include <linux/autoconf.h>
#ifdef MODULE
#include <linux/module.h>  /* Definitions needed for kernel modules */
#endif
#include <linux/kernel.h>  /* We run in the kernel so we need this */
#include <linux/proc_fs.h> /* The /proc definitions are in this one */
#include <linux/types.h>
#include <linux/init.h>
#include <linux/rwsem.h>
#include <linux/rwsem-spinlock.h>
#include <linux/poll.h>
#include <linux/sched.h>
#include <linux/iosc/iosc-dev.h>

#ifdef CONFIG_IOSC_UNLOCKED_IOCTL
#define IOSC_ENABLE_UNLOCKED_IOCTL
#endif

#ifdef NO_DEBUG_MSG
#define iosc_msg(fmt, args...) /* do nothing */
#define iosc_msg_continue(fmt, args...) /* do nothing */
#define iosc_err(fmt, args...) 
#define iosc_msg_continue(fmt, args...) 
#else
/* #define iosc_msg(fmt, args...) printk(KERN_ERR "<iosc-dev> " fmt, ##args) */
#define iosc_debug(fmt, args...) printk(KERN_DEBUG fmt, ##args)
#define iosc_msg(fmt, args...) printk(KERN_INFO fmt, ##args)
#define iosc_err(fmt, args...) printk(KERN_ERR fmt, ##args)
#define iosc_msg_continue(fmt, args...) printk(fmt, ##args)
#endif

#define IOSC_VERSION "0.3 (" __DATE__ " - " __TIME__ ")"

#define IOSC_MAX_KMALLOC    (64<<10)

/* control packet structure */
struct ctlpacket {
    struct list_head list;      /* List management structure */
    unsigned int cmd;           /* command */
    size_t length;              /* data size */
    void *args;                 /* data address */
};

/* data packet structure */
struct datapacket {
    struct list_head list;      /* List management structure */
    size_t length;              /* data size */
    char data[0];               /* data */
};

/* packet queue structure */
struct iosc_packet_queue_t {
    wait_queue_head_t   wait;            /* event waiting queue */
    struct list_head  ctlpacket_list;    /* list of received control packet */
    struct list_head  datapacket_list;   /* list of received data packet */
    spinlock_t ctlpacket_lock;           /* lock to access control pacekt list */
    spinlock_t datapacket_lock;          /* lock to access data pacekt list */
    size_t  offset;                      /* next read offset of data packet */
    struct datapacket   *remain;         /* unread data packet */
};


/* data block structure */
struct iosc_data_block_t {
    wait_queue_head_t wait;
    spinlock_t lock;
    size_t length;
    char *data;
};

/* prototype definition of common function */
extern void *alloc_memory( size_t size );
extern void free_memory( void *ptr );
extern void *local_alloc_memory(size_t size);
extern void local_free_memory(void *ptr);

extern void init_packet_queue( struct iosc_packet_queue_t *queue );
extern void clean_packet_queue( struct iosc_packet_queue_t *queue );

extern int put_ctlpacket(unsigned int listid, int memid);
extern struct ctlpacket *get_ctlpacket( struct iosc_packet_queue_t *from );

extern int put_datapacket(unsigned int listid, int memid);
extern struct datapacket *get_datapacket( struct iosc_packet_queue_t *from );
extern void wake_up_datapacket( struct iosc_packet_queue_t *queue );
extern void wait_datapacket( struct iosc_packet_queue_t *queue );

extern void wait_packet_queue( struct iosc_packet_queue_t *from );

extern ssize_t read_datapacket( struct iosc_packet_queue_t *queue, char *buf, size_t nbytes );
extern ssize_t write_datapacket(unsigned int listid, char *buf, size_t nbytes);
extern int send_ctlpacket(unsigned int listid, unsigned int cmd, void *args, size_t size);
extern int send_ctlpacket_self(struct iosc_packet_queue_t *queue, unsigned int cmd, void *args, size_t size);
extern int receive_ctlpacket(struct iosc_packet_queue_t *queue, struct iosc_read_packet_t *packet);

extern int init_datablock( struct iosc_data_block_t *block, int nblk );
extern int clean_datablock(struct iosc_data_block_t *block, int nblk);
extern int get_datablock( struct iosc_data_block_t *block, char *data, size_t length );
extern int set_datablock(unsigned int listid, char *data, size_t length);


//#define clear_tsk_thread_flag(tsk,flg) ((tsk)->sigpending) = 0
//#define recalc_sigpending() /*do nothing*/

#endif /* IOSC_INTERNAL_DEV_H */
